(function ($) {

    $.fn.eilmeldung = function ( options ) {

        var breakingnews_url = 'http://json.zeit.de/eilmeldung/eilmeldung?callback=?';

        if (location.href.search(/https:/) > -1) {
          breakingnews_url = 'https://ssl.zeit.de/json.zeit.de/eilmeldung/eilmeldung?callback=?'
        }

     	var options = $.extend({
			debug: 0,
			blacklist: ['services.zeit.de', 'www.zeit.de', 'localhost', 'zip6.zeit.de'],
			src: breakingnews_url
		}, options);
		
		isOnBlacklist = function() {
			return $.inArray( true, jQuery.map(options.blacklist, function( n, i ) {
				if( location.href.indexOf( n ) > -1) { return true; }
			}));
		};

        var that = this;
        
        return this.each( function () {
			if( isOnBlacklist() < 0 || options.debug ) {
				
				if( options.debug ) {
					options.src = 'http://zip6.zeit.de/preview-json/eilmeldung/eilmeldung?callback=?';
				}
				
				$.getJSON( options.src, function( json ) {
					if( json ) {
						if( json['article'][1]['body'][0].division !== undefined ) {
							var values = {
								body: $( json['article'][1]['body'][0].division ).text()
							};
							for ( var i=0; i < json['article'][0]['head'].length; i++) {
								if( json['article'][0]['head'][i].attribute.name == "pubtime_local" ) values.pubtime_local = json['article'][0]['head'][i].attribute.value;
								if( json['article'][0]['head'][i].attribute.name == "published" ) values.published = json['article'][0]['head'][i].attribute.value;
							}
							if( values.published === "yes" || options.debug ) {
								var msg = '<div class="newsflash clear"><div class="inner clear"><div class="flash">Eilmeldung</div><div class="msg"><p>' + values.body + '&nbsp;<span>|&nbsp;' + values.pubtime_local + '</span></p></div></div></div>';
								if( $( '#header #place_3' ).size() > 0 ) {
									$( msg ).hide().insertBefore( '#header #place_3' ).show( 10 );
								} else {
									$( msg ).hide().appendTo( that ).show( 10 );
								}
							}
						}
					}
				});
			}
        });
        
    };

})(jQuery);